#!BPY

# """
# Name: 'J3C code (.j3c)'
# Blender: 237
# Group: 'Export'
# Tooltip: 'Export to J3C format.'
# """

import Blender, os, math
from Blender import sys, BGL, NMesh, Scene, Object, Material, Draw, Window

__author__ = 'Jun Mizutani'
__version__ = '0.6 2006/01/04'
__url__ = ["Author's site, http://www.nk.rim.or.jp/~jun/" ]
__bpydoc__ = """\
This script exports vertices and faces to j3c format for
J3W:3D polygon animation kit(http://www.nk.rim.or.jp/~jun/j3w/).
"""

# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****

# -----------------------------
# フォームの処理
# -----------------------------
def gui ():
	global filename, exportDir
	global factor, menu_val, menu, info
	global objview, anim, speed, dist
	global maxx, minx, maxy, miny, maxz, minz
	global meshobj_names, mesh_vertex, mesh_face
	global spec, rot_X, rot_Y, rot_Z

	BGL.glClearColor(0.72, 0.72, 0.72, 0.0)
	BGL.glClear(BGL.GL_COLOR_BUFFER_BIT)
	BGL.glColor3i(0,0,0)
	BGL.glRasterPos2i(10, 380)
	Draw.Text('J3C Exporter')

	# メニューによるメッシュ選択
	menu_list = 'Select Object %t|'
	menu_list= menu_list + '| All %x0 %|'
	i=1
	for mname in meshobj_names:
		menu_list= menu_list + '| Mesh : ' + mname + '%x' + str(i)
		i+=1

	menu = Draw.Menu(menu_list, 20, 10, 340, 290, 20, menu.val, 'Mesh Select')
	menu_val=menu.val

	# メッシュの頂点数と面数の表示
	BGL.glRasterPos2i(10, 320);
	if (menu.val != 0):
		mname = meshobj_names[menu.val-1]
		Draw.Text('%s: %5d vertices , %5d faces' %
				(mname, mesh_vertex[mname], mesh_face[mname]))
	else:
		verts, faces = 0, 0
		for mname in meshobj_names:
			verts += mesh_vertex[mname]
			faces += mesh_face[mname]
		Draw.Text('All: %5d vertices , %5d faces' % (verts, faces))


	# 表示情報の選択
	info_list = 'Select Item %t|'
	info_list= info_list + '| Size %x1| Origin %x2| Scale %x3| Angle %x4'

	info = Draw.Menu(info_list, 20, 10, 290, 290, 20, info.val, 'Object Information Select')
	info_val=info.val

	# 拡大率の設定
	factor = Draw.Number('Factor:', evMUL, 10, 260, 140, 18, factor.val, 0.01, 1000)

	if info_val == 1:
		# 変換後の頂点座標の最大最小値
		max = round(maxx*factor.val)
		min = round(minx*factor.val)
		BGL.glRasterPos2i(30, 240)
		Draw.Text('[X]  min:%5d  max:%5d,  size:%5d' % (min, max, max-min))
		BGL.glRasterPos2i(30, 220)
		max = round(maxy*factor.val)
		min = round(miny*factor.val)
		Draw.Text('[Y]  min:%5d  max:%5d,  size:%5d' % (min, max, max-min))
		BGL.glRasterPos2i(30, 200)
		max = round(maxz*factor.val)
		min = round(minz*factor.val)
		Draw.Text('[Z]  min:%5d  max:%5d,  size:%5d' % (min, max, max-min))
	if info_val == 2:
		# 変換後の原点座標
		mname = meshobj_names[menu.val-1]
		origin = getOrigin(mname)
		BGL.glRasterPos2i(30, 240)
		Draw.Text('%s Origin X: %5d' % (mname, origin[0]))
		BGL.glRasterPos2i(30, 220)
		Draw.Text('%s Origin Y: %5d' % (mname, origin[1]))
		BGL.glRasterPos2i(30, 200)
		Draw.Text('%s Origin Z: %5d' % (mname, origin[2]))
	if info_val == 3:
		# Scaleの表示
		scale = getScale(mname)
		BGL.glRasterPos2i(30, 240)
		Draw.Text('%s Scale X: %5.3f' % (mname, scale[0]))
		BGL.glRasterPos2i(30, 220)
		Draw.Text('%s Scale Y: %5.3f' % (mname, scale[1]))
		BGL.glRasterPos2i(30, 200)
		Draw.Text('%s Scale Z: %5.3f' % (mname, scale[2]))
	if info_val == 4:
		# Angleの表示
		const = 360/(2*math.pi)
		ob = Object.Get(mname)
		rotation = getRotation(mname)
		BGL.glRasterPos2i(30, 240)
		Draw.Text('%s Bank  : %5.1f' % (mname, rotation[0]))
		BGL.glRasterPos2i(30, 220)
		Draw.Text('%s Pitch : %5.1f' % (mname, rotation[1]))
		BGL.glRasterPos2i(30, 200)
		Draw.Text('%s Head  : %5.1f' % (mname, rotation[2]))

	# ファイルとパスの指定
	filename = Draw.String('Filename: ', evFNAME, 10, 160, 270, 19, \
							 filename.val, 200, 'export file name')
	Draw.Button('...', evFILE, 281, 160, 19, 19, 'Browse for file name')

	exportDir = Draw.String('Path: ', evPNAME, 10, 135, 270, 19, exportDir.val, \
							 200, 'Export file directory')
	Draw.Button('...', evPATH, 281, 135, 19, 19, 'Browse for directory')

	dist = Draw.Number('Distance', evDIST, 10, 100, 140, 18, dist.val, 10, 10000, 'How far the camera is.')
	objview = Draw.Toggle('J3W Viewer code', evVIEW, 160, 100, 140, 18, objview.val, 'for blendview.j3c')

	spec = Draw.Number('Specular:', evSPEC,  10, 80, 140, 18, spec.val, 10, 500, 'Set specular')
	rot_X = Draw.Toggle('Bank',  evROTX, 160, 80, 45, 18, rot_X.val, 'Set X rotation')
	rot_Y = Draw.Toggle('Pitch', evROTY, 207, 80, 46, 18, rot_Y.val, 'Set Y rotation')
	rot_Z = Draw.Toggle('Head',  evROTZ, 255, 80, 45, 18, rot_Z.val, 'Set Z rotation')

	anim = Draw.Toggle('Anim.', evANIM, 10, 60, 70, 18, anim.val, 'simple animation')
	speed = Draw.Toggle('Fast', evSPEED, 80, 60, 70, 18, speed.val, 'move faster')
	Draw.Button('Run J3W', evRUN, 160, 60, 140, 18, 'Run J3W')

	# 変換の実行ボタン
	Draw.Button('Export J3C', evEXP, 10, 20, 140, 30, 'Create a new export file')

	# 終了ボタン
	Draw.Button('Exit', evEXIT, 160, 20, 140, 30, 'Exit this script')

# -----------------------------
def exitScript ():
	print 'Export finished.'
	Draw.Exit()

# -----------------------------
def event (evt, val):
	if (evt == Draw.ESCKEY and not val):
		exitScript()

# -----------------------------
def FileSelectCallback(fname):
	global filename
	filename.val = os.path.basename(fname)

# -----------------------------
def DirSelectCallback(fname):
	global exportDir
	exportDir.val = os.path.dirname(fname)

# -----------------------------
# ボタンイベント処理
def button_event (evt):
	global exportDir, filename
	global factor, menu_val
	global CONSOLE, dir

	# Export ボタン
	if (evt == evEXP):
		exportClick();
	# EXIT ボタン
	if (evt == evEXIT):
		exitScript()
	# ファイル指定
	if (evt == evFILE):
		Window.FileSelector(FileSelectCallback, 'Export Filename', 'blend.j3c')
	# ディレクトリ指定
	if (evt == evPATH):
		Window.FileSelector(DirSelectCallback, 'Export Path', dir)
	if (evt == evRUN):
		export(sys.join (exportDir.val, filename.val))
		print CONSOLE + 'j3cc -r ' + exportDir.val + '/blendview.j3c'
		os.system(CONSOLE + 'j3cc -r ' + exportDir.val + '/blendview.j3c &')

	# センタリングボタン
	Draw.Draw()

# -----------------------------
# Export ボタン処理
def exportClick ():
	global exportDir, filename
	export(sys.join (exportDir.val, filename.val))
	Draw.Draw()

# -----------------------------
def getOrigin(name):
	global factor

	ob = Object.Get(name)
	origin[0] = round(ob.LocY*factor.val)
	origin[1] = round(ob.LocX*factor.val)
	origin[2] = -round(ob.LocZ*factor.val)
	return origin

# -----------------------------
def getScale(name):
	global factor

	scale = [0.0, 0.0, 0.0]
	ob = Object.Get(name)
	scale[0] = ob.SizeY
	scale[1] = ob.SizeX
	scale[2] = ob.SizeZ
	return scale

# -----------------------------
# オイラー角の取得
# 回転順序の変換が必要か？
def getRotation(name):
	rotation = {}
	const = 360*8/(2*math.pi)
	ob = Object.Get(name)
	rotation[0] = round(ob.RotY * const)    # Bank
	rotation[1] = round(ob.RotX * const)    # Pitch
	rotation[2] = -round(ob.RotZ * const)   # Head
	return rotation

# -----------------------------
# 変換の実行
def export (pathname):
	global meshobj_names, mesh_vertex, mesh_face
	global objview, anim, speed, dist
	global spec, rot_X, rot_Y, rot_Z
#	global rotation

	editmode = Window.EditMode()
	if editmode: Window.EditMode(0)

	cnt_vertex = 0
	cnt_face = 0
	# color 番号の15から下に向かって再定義
	color = 15
	mat_color = {}
	vert_buf = {}

	ex_file = open (pathname, 'w')
	print 'Opened: ' + ex_file.name
	ex_file.write('// output from blender by J3C Exporter')
	ex_file.write('\n')

	for name in meshobj_names:
		# !!!
		me = NMesh.GetRawFromObject(name)
		ex_file.write('\n')
		ex_file.write('class %s {' % (name.replace('.','_')))
		ex_file.write('\n')
		ex_file.write('  volatile int color[16];')
		ex_file.write('\n')
		ex_file.write('\n')
		ex_file.write('  int shape() {')
		ex_file.write('\n')

		# NMVert のリスト
		# index でNMesh内の頂点インデックスを参照することができる。
		ex_file.write('    VertexRelative();')
		ex_file.write('\n')
		cnt_vertex = len(me.verts)
		ex_file.write('    // %5d vertices' % cnt_vertex)
		ex_file.write('\n')

		# オブジェクトの原点の位置を取得
		# 原点座標は J3W 系に変換
		origin = getOrigin(name)
		rotation = getRotation(name)

		# 頂点座標は J3W 系に変換
		# X -> Y, Y -> X, Z -> -Z
		ob = Object.Get(name)
		for v in me.verts:
			ex_file.write('    DefPoint(')
			ex_file.write('%5d, %5d, %5d);   // %4d' % (
					round(v.co[1]*factor.val*ob.SizeY),
					round(v.co[0]*factor.val*ob.SizeX),
					-round(v.co[2]*factor.val*ob.SizeZ), v.index))
			ex_file.write('\n')

		# 面(face)の頂点データは NMVert のリストとして返される
		# index でNMesh内の頂点インデックスを参照することができる。
		cnt_face = len(me.faces)
		ex_file.write('    // %5d faces' % cnt_face)
		ex_file.write('\n')
		for f in me.faces:
			ex_file.write('    DefPlane(')
			ex_file.write('color[%d], %4d' % (f.mat, len(f.v)))
			# 頂点番号をバッファに格納
			# 頂点番号を順に指定 
			for v in f.v:							# アドレスのリストが返る
				ex_file.write(', %4d' % (v.index))	# 頂点インデックス
			ex_file.write(');')
			ex_file.write('\n')

		ex_file.write('  }')
		ex_file.write('\n')

		ex_file.write('  int initialize() {')
		ex_file.write('\n')
		ex_file.write('    // NewObject(%d, %d);' % (cnt_vertex, cnt_face))
		ex_file.write('\n')

		# マテリアルの色を出力
		# 複数のマテリアルに対応
		num_color=0
		for mat in me.getMaterials():
			mat_color[num_color]=color
			ex_file.write('    color[%d] = %d;' % (num_color, color))
			ex_file.write('\n')
			ex_file.write('    RX = %3d;' % round(mat.rgbCol[0]*255))
			ex_file.write('\n')
			ex_file.write('    RY = %3d;' % round(mat.rgbCol[1]*255))
			ex_file.write('\n')
			ex_file.write('    RZ = %3d;' % round(mat.rgbCol[2]*255))
			ex_file.write('\n')
			ex_file.write('    SetColor(color[%d]);' % num_color)
			ex_file.write('\n')
			color -= 1
			num_color += 1
		ex_file.write('\n')
		ex_file.write('    Specular(%d);' % spec.val)
		ex_file.write('\n')
		ex_file.write('    Ambient(0);')
		ex_file.write('\n')
		ex_file.write('    shape();')
		ex_file.write('\n')
		ex_file.write('  }')
		ex_file.write('\n')
		ex_file.write('  int INIT() {')
		ex_file.write('\n')
		ex_file.write('    initialize();')
		ex_file.write('\n')
		ex_file.write('    ClearRegisters();')
		ex_file.write('\n')

		ex_file.write('    RX = %3d;' % origin[0])
		ex_file.write('\n')
		ex_file.write('    RY = %3d;' % origin[1])
		ex_file.write('\n')
		ex_file.write('    RZ = %3d;' % origin[2])
		ex_file.write('\n')
		ex_file.write('    RH = %3d;' % rotation[2])
		ex_file.write('\n')
		ex_file.write('    RP = %3d;' % rotation[1])
		ex_file.write('\n')
		ex_file.write('    RB = %3d;' % rotation[0])
		ex_file.write('\n')
		ex_file.write('    SetPosition();')
		ex_file.write('\n')

		ex_file.write('  }')
		ex_file.write('\n')
		ex_file.write('  int RUN() {')
		ex_file.write('\n')
		if (anim.val != 0):
			time = 10000
			if (speed.val != 0):
				time = 2000
			if (rot_X.val != 0):
				ex_file.write('    RotBank(%5d, 2880);' % time)
				ex_file.write('\n')
			if (rot_Y.val != 0):
				ex_file.write('    RotPitch(%5d, 2880);' % time)
				ex_file.write('\n')
			if (rot_Z.val != 0):
				ex_file.write('    RotHead(%5d, 2880);' % time)
				ex_file.write('\n')
		ex_file.write('  }')
		ex_file.write('\n')
		ex_file.write('  int EVENT() {')
		ex_file.write('\n')
		ex_file.write('  }')
		ex_file.write('\n')
		ex_file.write('}                       // class %s' % (name))
		ex_file.write('\n')

	if (objview.val != 0) :
		ex_file.write('\n')
		ex_file.write('// Parent class')
		ex_file.write('\n')
		ex_file.write('class model {')
		ex_file.write('\n')
		ex_file.write('  int INIT() {')
		ex_file.write('\n')
		ex_file.write('    BackgroundColor(0x000);')
		ex_file.write('\n')
		ex_file.write('    NewObject(0,0); ')
		ex_file.write('\n')
		ex_file.write('    ClearRegisters();')
		ex_file.write('\n')
		ex_file.write('    SetPosition();')
		ex_file.write('\n')

		for name in meshobj_names:
			ex_file.write('    child(%s, 100, %4d, %4d);' %
			(name.replace('.','_'), mesh_vertex[name], mesh_face[name] ))
			ex_file.write('\n')

		ex_file.write('\n')
		ex_file.write('  }')
		ex_file.write('\n')
		ex_file.write('  int RUN() {}')
		ex_file.write('\n')
		ex_file.write('  int EVENT() {}')
		ex_file.write('\n')
		ex_file.write('}')
		ex_file.write('\n')
		ex_file.write('\n')
		ex_file.write('library constants {')
		ex_file.write('\n')
		ex_file.write('  final int distance = %d;' % dist.val)
		ex_file.write('\n')
		ex_file.write('}')
		ex_file.write('\n')


	if (not ex_file.closed):
		ex_file.close();

	if editmode: Window.EditMode(1)

# -----------------------------
# main
# -----------------------------

CONSOLE = 'kterm -e '
#CONSOLE = 'kterm -km euc -fr r12 -fk k12 -sb -sl 200 -e '

evEXP   = 1
evEXIT  = 2
evFNAME = 3
evFILE  = 4
evPNAME = 5
evPATH  = 6
evVIEW  = 7
evSPEED = 8
evANIM  = 9
evRUN   = 10
evMUL   = 11
evDIST  = 12
evROTX  = 13
evROTY  = 14
evROTZ  = 15
evSPEC  = 16

maxx = -99999999
minx = 99999999
maxy = -99999999
miny = 99999999
maxz = -99999999
minz = 99999999

origin = [0, 0, 0]
#rotation = {}

#scene = Scene.getCurrent()
for obname in Object.Get():
	if obname.getBoundBox() != None:
		print obname, obname.getType()
		for v in obname.getBoundBox():
			if v[0] > maxx:
				maxx = v[0]
			if v[0] < minx:
				minx = v[0]
			if v[1] > maxy:
				maxy = v[1]
			if v[1] < miny:
				miny = v[1]
			if v[2] > maxz:
				maxz = v[2]
			if v[2] < minz:
				minz = v[2]

print 'MinX = %d  MaxX = %d ' % (minx, maxx)
print 'MinY = %d  MaxY = %d ' % (miny, maxy)
print 'MinZ = %d  MaxZ = %d ' % (minz, maxz)

menu = Draw.Create(0)
info = Draw.Create(1)

# 拡大率
factor = Draw.Create(50.0)

rot_X = Draw.Create(0)
rot_Y = Draw.Create(0)
rot_Z = Draw.Create(1)
spec  = Draw.Create(100)
dist = Draw.Create(500.0)

center = [0, 0, 0]

objview = Draw.Create(1)
speed = Draw.Create(0)
anim = Draw.Create(1)

mesh_vertex = {}
mesh_face = {}
meshobj_names = []

print '--Object names'
for obj in Object.Get():
	data = obj.getData()
	if obj.getType() ==  'Mesh':
		data = obj.getData()
		print obj.name
		print data.name
		# !!!
		me = NMesh.GetRawFromObject(obj.name)
		if me != None:
			meshobj_names.append(obj.name)
			mesh_vertex[obj.name] = len(me.verts)
			mesh_face[obj.name] = len(me.faces)
		print

if os.environ.has_key('J3WBLEND'):
	dir = os.environ['J3WBLEND']
else:
	dir = os.environ['HOME']
exportDir = Draw.Create(dir)
filename = Draw.Create('blend.j3c')
menu_val = 0

Draw.Register (gui, event, button_event)

