#!/usr/bin/perl
# optimizer for j3c v.1.02
#  11/25/99 Jun Mizutani
#
# 2行読み込み，2行目が"        LOAD    R1  R4"で
# 1行目に R4 があれば，1行目の R4 を R1 に置換し，1行目を
# 書き出し，2行目は出力しない．ただし1行目がNEG命令または
# POP命令がある場合は最適化しない．
#
# usage : j3opt.pl list13.j3m

    local($FILE)=$ARGV[0];
    $FILE =~ s/.j3m$//;
    local($NEWFILE)=$FILE.".j3o";
    $FILE = $FILE.".j3m";
    print "$FILE --> $NEWFILE\n";
    open(IN, $FILE) || die "$FILE : $!";
    open(OUT, ">$NEWFILE") || die "$NEWFILE : $!";

    $oldline="";
    while ($line=<IN>) {
        if (($line =~ /        LOAD    R1  R4/) &&
            ($oldline !~ /\sNEG\s/) &&
            ($oldline !~ /\sPOP\s/)) {
            if ($oldline =~ /\sR4\s/) {
                $oldline =~s/R4/R1/;
                print OUT $oldline;
            $oldline = "";
            }
        } else {
            print OUT $oldline;
            $oldline = $line;
        }

    }
    print OUT $oldline;

