/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler main)                                */
/*  j3c.cpp         08/06/2012                                             */
/*  Copyright (C) 1998 - 2012 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <iostream>
#include <string.h>
#include "j3c_pars.h"
#include "j3c_misc.h"
using namespace std;

const char* VersionStr = " J3C ver. 1.11 2012 Jun Mizutani \n";

cParse*  parse;

void usage() {
     cout << VersionStr;
     cout <<"usage : j3c filename\n";
     cout <<"        j3c - filename\n";
}

int main(int argc, char* argv[]) {
    char SourceFileName[PATHLEN];
    char ObjectFileName[PATHLEN];

    if (argc>1) {
        if (strcmp(argv[1], "-") == 0) {
            if ((argc==3) && (*argv[2]!='-')) {
                strncpy(SourceFileName, argv[2], PATHLEN - 1);
                strcpy(ObjectFileName, "");
                parse = new cParse();
                parse -> parse(SourceFileName, ObjectFileName);
                delete parse;
            } else
                usage();
        } else if ((argc==2) && (*argv[1]!='-')) {
            cout << VersionStr;
            strcpy(SourceFileName, argv[1]);
            cout << "     Source File : " << SourceFileName << '\n';
            RemoveExtention(SourceFileName, ObjectFileName);
            strcat(ObjectFileName, ".j3m");
            cout << "     Assembly File : " << ObjectFileName << '\n';
            parse = new cParse();
            parse -> parse(SourceFileName, ObjectFileName);
            cout << '\n';
            delete parse;
        } else
            usage();
    } else
        usage();
    return 0;
}
