/*-------------------------------------------------------------------------*/
/*  J3W    3D Animation Kit  (compiler)                                    */
/*  j3c_asm.h      8/06/2012                                               */
/*  Copyright (C) 1998 - 2012 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3c_asm_h)
#define _j3c_asm_h

#include <iostream>
#include <fstream>
#include <string.h>
#include "j3c_stak.h"

using namespace std;

class cAsmFile {
    ofstream dist_file;
    ostream  &dist;
    char* p;
    int optimize;
    int factor_count;
    cStack* fcount;
  public:
    cAsmFile(ostream &os);
    ~cAsmFile();
    void opt_begin() { optimize = 0; };
    void opt_exp() { optimize++; };
    void enter_exp() { fcount->push(factor_count); factor_count = 0; };
    void exit_exp() { factor_count = fcount->pop(); };
    void count_factor() { factor_count++; };
    int  get_factor_count() { return factor_count; };
    void eol();
    void label(string lb);
    void opcode(string op, string operand);
    void comment(string comment);
    void jump(string label);
    void begin(string name);
    void init_begin(string name);
    void init_end();
    void method_begin(string name);
    void method_end();
    void run_begin(string name);
    void run_end(string name);
    void event_begin(string name);
    void event_end(string name);
    void exp1();
    void exp2(int sym, string lb1, string lb2);
    void simple_exp1();
    void simple_exp2(int sym);
    void term1();
    void term2(int sym);
    void paren1();
    void paren2();
    void minus();
    void not0();
    void character(char ch);
    void var_ref(int addr);
    void array_ref(int addr);
    void param_ref(int pos);
    void local_ref(int val, int nest);
    void array_ref1();
    void array_ref2(int addr);
    void number(int num);
    void assign(int value);
    void assign_param(int value);
    void assign_local(int val, int nest);
    void assign_array1();
    void assign_array2(int addr);
    void if1(string lb1);
    void if2(string lb1, string lb2);
    void if3(string lb2);
    void while1(string lb1);
    void while2(string lb2);
    void while3(string lb1, string lb2);
    void do1(string lb1);
    void do2(string lb1, string lb2);
    void switch1();
    void switch2(string lb1, string lb2, string lb3, int val);
    void switch3(string lb4);
    void switch4(string lb5);
    void switch5(string lb6);
    void return0();
    void break0(string lb);
    void continue0(string lb);
    void for1(string lb1);
    void for2(string lb2, string lb3, string lb4);
    void for3(string lb1, string lb3);
    void for4(string lb2, string lb4);
    void enter(int n);
    void leave();
    void set_param();
    void method_call(string cname, string mname);
    void method_return(int param_no);
    void func_param1();
    void func_param2();
    void assign_register(int sym);
    void ref_register(int sym);
};

#endif
