/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_func.cpp   10/27/2008                                              */
/*  Copyright (C) 1998 - 2008 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <stdio.h>
#include "j3c_func.h"
#include "j3c_word.h"

using namespace std;

    /* parameter parse table */

ParamFormatType ParamFormatTable[] = {
        { NOOP  , 0x40000000 }, { THROW , 0x00000000 }, { INC   , 0x40000000 },
        { DEC   , 0x40000000 }, { NOT   , 0x50000002 }, { SQRT  , 0x40000002 },
        { SIN   , 0x40000002 }, { COS   , 0x40000002 }, { ATAN  , 0x50000000 },
        { RANDOM, 0x40000002 }, { CLEARA, 0x00000000 }, { PUSHA , 0x00000000 },
        { POPA  , 0x00000000 }, { CALLTB, 0x50000000 }, { CLOAD , 0x40000002 },
        { CSTORE, 0x50000000 }, { GENPRC, 0xF0000000 }, { DELPRC, 0x00000000 },
        { WAIT  , 0x00000000 }, { STPALL, 0x00000000 }, { SEND  , 0x50000000 },
        { RECEIV, 0x00000002 }, { SENDTO, 0x50000000 }, { CHILD , 0xFF000000 },
        { GRAPHM, 0x00000000 }, { TEXTM , 0x00000000 }, { BCOLOR, 0x40000000 },
        { ZOOM  , 0x40000000 }, { WIRE  , 0x40000000 },
        { PNTUV , 0x00000001 }, { DEFPNT, 0xFFC00000 }, { TXFILE, 0xE0000000 },
        { TXSET,  0x40000000 }, { TXAXIS, 0x40000000 }, { TXALPH, 0x40000000 },
            { TXSCAL, 0x50000000 }, { TXCHG,  0x50000000 }, { TXMAP,  0x40000000 },
            { TXBIAS, 0x50000000 }, { NEAR  , 0x40000000 }, { FAR   , 0x40000000 },
        { EMIT  , 0x40000000 }, { PARALL, 0x40000000 },
        { INKEY , 0x00000002 }, { RAWKEY, 0x40000002 }, { MOUSE , 0x00000001 },
        { OUTNUM, 0x40000000 }, { OUTCHR, 0x40000000 }, { OUTSTM, 0x70000000 },
        { OUTSTR, 0x80000000 }, { NOTE  , 0xFC000000 }, { MIDI  , 0xFC000000 },
        { MOVF  , 0x50000000 }, { MOVB  , 0x50000000 }, { MOVL  , 0x50000000 },
        { MOVR  , 0x50000000 }, { MOVU  , 0x50000000 }, { MOVD  , 0x50000000 },
        { ROTH  , 0x50000000 }, { ROTP  , 0x50000000 }, { ROTB  , 0x50000000 },
        { MOVALL, 0x40000001 }, { MOVALH, 0x40000001 }, { SCALE , 0x40000001 },
        { SETGRV, 0x40000000 }, { GETGRV, 0x00000002 }, { SETACL, 0x00000001 },
        { GETACL, 0x00000001 }, { SETVEL, 0x00000001 }, { GETVEL, 0x00000001 },
        { SETWVL, 0x00000001 }, { GETWVL, 0x00000001 }, { GENOBJ, 0xF0000000 },
        { DEFPNT, 0xFC000000 }, { DEFPLN, 0x7FFFFFFC }, { DELOBJ, 0x00000000 },
        { SETEYE, 0x00000000 }, { POINT , 0x00000001 }, { SETREF, 0x40000000 },
        { SETAMB, 0x40000000 }, { GETVXN, 0x00000002 },
        { PLANE , 0x40000000 }, { TRANSP, 0x00000001 }, { UPDTVP, 0x00000000 },
        { RSETVP, 0x00000000 }, { SLIDE , 0x00000001 }, { HOME  , 0x00000000 },
        { GETPOS, 0x00000001 }, { SETPOS, 0x00000001 }, { PRCPOS, 0x40000001 },
        { DISTNC, 0x40000001 }, { PRIOR , 0x40000000 }, { RELATV, 0x40000001 },
        { LOOK  , 0x40000001 }, { RELAT2, 0x00000001 }, { FINDVX, 0x00000001 },
        { SETVTX, 0x00000001 }, { GETVTX, 0x00000001 }, { SETPLN, 0x00000000 },
        { GETPLN, 0x00000000 }, { SETSCL, 0x00000001 }, { GETSCL, 0x00000001 },
        { GRNUM , 0x40000000 }, { GRCHR , 0xC0000000 }, { GRSTM , 0x70000000 },
        { GRSTR , 0x80000000 }, { GRCOL , 0x40000000 }, { GRCLR , 0x00000000 },
        { GRCSR , 0x40000000 }, { GRPOS , 0x00000002 }, { GRLINE, 0x00000001 },
        { GRLINC, 0x40000000 }, { SYSTIM, 0x00000002 }, { SYSCNT, 0x00000002 },
        { SYSPRC, 0x00000002 }, { DATA  , 0x7FFFFFFC }, { WRITE , 0x80000001 },
        { READ  , 0x80000001 }, { LIGHT , 0x40000000 }, { COLNUM, 0x00000002 },
        { COLWDT, 0x00000002 }, { CNTVTX, 0x00000002 }, { CNTPLY, 0x00000002 },
        { SETCOL, 0x40000001 }, { RSTCOL, 0x00000000 }, { VER   , 0x00000001 }
    };

cParamFormat::cParamFormat(int size) : tab_size(size), pos(0)
{
    tab = new eParamFormat[tab_size];
    op_size = sizeof(ParamFormatTable)/sizeof(ParamFormatType);
}

cParamFormat::~cParamFormat()
{
    delete [] tab;
}

int cParamFormat::get_format(int op)
{
    curr = &tab[pos];
    curr->operand = "  ";
    int i = 0;
    while (i < op_size) {
        if (ParamFormatTable[i].op == op) break;
        i++;
    }
    if (i == op_size) return 0;
    curr->pf = ParamFormatTable[i].pf;
    curr->reg_x_b = curr->pf & 1;
    curr->hide_reg = ((curr->pf & 2) != 0);
    curr->pf &= 0xFFFFFFFC;
    if (pos < tab_size-1) pos++;
    return 1;
};

void cParamFormat::end_format()
{
    if (pos > 0) pos--;
    if (pos > 0) curr = &tab[pos - 1];
    else curr = 0;
}

int cParamFormat::get_field()
{
    curr->pf0 = (curr->pf & 0xC0000000) >> 30;
    curr->pf <<= 2;
    return curr->pf0;
}

void cParamFormat::add_value(int val)
{
    char v[20];
    sprintf(v, " %d ", val);
    curr->operand = curr->operand + v;
};

