/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_func.h     08/06/2012                                              */
/*  Copyright (C) 1998 - 2012 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3c_func_h)
#define _j3c_func_h

#include <string>

using namespace std;

struct ParamFormatType {
    int  op;
    unsigned int  pf;
};

struct eParamFormat {
    int  pf0;
    int  reg_x_b;
    int  hide_reg;
    int  pf;
    string operand;
};

class cParamFormat {
    int  op_size;
    int  tab_size;
    int  pos;
    eParamFormat* tab;
    eParamFormat* curr;
  public:
    cParamFormat(int size);
    ~cParamFormat();
    int  get_format(int op);
    void end_format();
    int  get_field();
    int  register_use()  { return curr->reg_x_b; };
    int  hide_register() { return curr->hide_reg; };
    void add_format(string fmt) { curr->operand = curr->operand + fmt; };
    void add_str(char *str) {
        curr->operand = curr->operand + "\"" + str + "\"";
    };
    void add_value(int val);
    string get_operand() { return curr->operand; };
};

#endif
