/*-------------------------------------------------------------------------*/
/*  J3W    3D Animation Kit  (compiler)                                    */
/*  j3c_labl.cpp      5/08/2003                                            */
/*  Copyright (C) 1998 - 2003 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <stdio.h>
#include "j3c_labl.h"

using namespace std;

cLabel::cLabel():seq(0)
{ }

void cLabel::set_cname(string c_name)
{
    cname = c_name;
    seq = 0;
    mname = "";
}

void cLabel::set_mname(string m_name)
{
    mname = m_name;
    seq = 0;
}

string cLabel::get_cname()
{
    return cname;
}

string cLabel::get_mname()
{
    return mname;
}

string cLabel::get_init_label()
{
    return cname + "_INIT:";
}

string cLabel::get_run_label()
{
    return cname + "_RUN:";
}

string cLabel::get_run_body_label()
{
    return cname + "_RUN_BODY:";
}

string cLabel::get_event_label()
{
    return cname + "_EVENT:";
}

string cLabel::get_label()
{
    char v[10];
    sprintf(v, "%d",seq);
    seq++;
    return cname + "_" + mname + "_"+ v + ":";
}

string cLabel::get_method_label()
{
    return cname + "_" + mname + ":";
}
