/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_lex.cpp     5/08/2003                                              */
/*  Copyright (C) 1998 - 2003 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include "j3c_lex.h"
#include "j3c_misc.h"

using namespace std;

cScanFiles::cScanFiles(int t_size) : table_size(t_size), p(0)
{
    Current = 0;
    strcpy(CurrentPath, "");
    ScanFile = new cScan*[table_size];
};

cScanFiles::~cScanFiles()
{
    CloseFile();
    delete [] ScanFile;
};

int cScanFiles::getsym()
{
    int sym = Current->getsym();
    if (sym == sym_EOF) {
        Current->CloseFile();
        p--;
        delete ScanFile[p];
        if (p > 0) {
            Current = ScanFile[p-1];
            sym = Current->getsym();
        }
    }

#ifdef DEBUG_SCAN
    char buf[LINEMAX];
    DecodeSymbol(buf, sym);
    cerr << buf << "  ";
#endif

    return sym;
}

int cScanFiles::OpenFile(char *FileName)
{
    char fname[PATHLEN];
    char fpath[PATHLEN];

    if (p < table_size) {
        ScanFile[p] = new cScan();
        Current = ScanFile[p];
        if (p > 0) strcpy(CurrentPath, ScanFile[p-1]->GetPath());
        else strcpy(CurrentPath,"");
        ExtractFilePath(FileName, fpath, fname);
        if (strlen(fpath) > 0) strcat(CurrentPath, fpath);
        SetPath(CurrentPath);
        p++;
        return Current->OpenFile(fname);
    } else return 0;
}

void cScanFiles::CloseFile()
{
    while (p > 0) {
        p--;
        ScanFile[p]->CloseFile();
        delete ScanFile[p];
    }
    Current = 0;
}

