/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_lex.h      08/06/2012                                              */
/*  Copyright (C) 1998 - 2012 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3c_lex_h)
#define _j3c_lex_h

#include "j3c_scan.h"
#include "j3c_misc.h"

class cScanFiles {
    cScan** ScanFile;
    cScan*  Current;
    char CurrentPath[PATHLEN];
    int  table_size;
    int  p;

  public:
    cScanFiles(int t_size);
    ~cScanFiles();
    int   Num()
          { return Current->Num(); };
    char* Word()
          { return Current->Word(); };
    int   Len()
          { return Current->Len(); };
    char* GetOpecodeName(int opc)
          { return Current->GetOpecodeName(opc); };
    char  GetChar(int idx)
          { return Current->GetChar(idx); };
    int   GetLineCount()
          { return Current->GetLineCount(); };
    int   GetColumn()
          { return Current->GetColumn(); };
    char* GetCurrentLine()
          { return Current->GetCurrentLine(); };
    const char* GetWordName(int sym)
          { return Current->GetWordName(sym); };
    char* GetCurrentFileName()
          { return Current->GetCurrentFileName(); };
    int   getsym();
    int   OpenFile(char *FileName);
    void  CloseFile();
    void  SetPath(char *PathName)
          { Current->SetPath(PathName); };
    char* GetPath()
          { return Current->GetPath(); };
    void  DecodeSymbol(char* buffer, int sym)
          { Current->DecodeSymbol(buffer, sym); };
};

#endif
