/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_misc.cpp     08/06/2012                                            */
/*  Copyright (C) 1998 - 2012 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <string.h>

using namespace std;

void ExtractFilePath(const char* filename, char* fpath, char* fname)
{
    int len = strlen(filename);
    int i = len;
#ifdef WIN32
    while ((filename[i] != '\\') && (filename[i] != '/') && (i >= 0)) i--;
#else
    while ((filename[i] != '/') && (i >= 0)) i--;
#endif
    i++;
    for(int j=0; j < len-i; j++) fname[j] = filename[i+j];
    fname[len - i] = 0;
    for(int j=0; j < i; j++)  fpath[j] = filename[j];
    fpath[i] = 0;
}

void ExtractFileName(const char* filename, char* fname)
{
    int len = strlen(filename);
    int i = len;
#ifdef WIN32
    while ((filename[i] != '\\') && (filename[i] != '/') && (i >= 0)) i--;
#else
    while ((filename[i] != '/') && (i >= 0)) i--;
#endif
    i++;
    for(int j=0; j < len-i; j++) fname[j] = filename[i+j];
    fname[len - i] = 0;
}

void RemoveExtention(const char* filename, char* name)
{
    int i = strlen(filename);
    while ((filename[i] != '.')&&(i >= 0)) i--;
    if (i > 0) {
        for(int j=0; j<=i; j++)
            name[j] = filename[j];
        name[i] = 0;
    } else {
        strcpy(name, filename);
    }
}

