/*-------------------------------------------------------------------------*/
/*  J3W    3D Animation Kit  (compiler)                                    */
/*  j3c_pars.h     01/02/2006                                              */
/*  Copyright (C) 1998 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3c_pars_h)
#define _j3c_pars_h

#include <fstream>
#include "j3c_symr.h"
#include "j3c_symc.h"
#include "j3c_asm.h"
#include "j3c_labl.h"
#include "j3c_lex.h"
#include "j3c_func.h"

class cParse {
    cScanFiles *scan;
    cSymRoot *SymTable;
    cClassTable *ClassTable;
    cAsmFile *code;
    cLabel label;
    cParamFormat *ParamFormat;
    ofstream os;
    int  std_out;
    int  ParsingLibrary;
    int  err;
    int  sym;
    int  kind;
    int  value;
    int  nest;
    string break_label;
    string continue_label;
    string const_str;
    char buffer[AL];

    void error(string str);
    void warning(const char* str);
    void debug(int no, int sym);
    void check_class();
    int  CheckIdent(int s);

    void def_import();
    void def_library();
    void def_class();
    void def_field();
    void def_method();
    void def_var_field();
    void def_var(int tbl_pos, int constant);
    void init_var(int tbl_pos);
    void const_exp_list(int tbl_pos);
    int  param_list();
    int  def_param(int num);
    void block(int meth);
    void statement_list();
    void local_var_decl(int &n);
    void def_local_var(int tbl_pos, int type);
    void statement();
    void stat_empty();
    void assign_stat();
    void assign_register(int sym_reg);
    void method_call();
    void lib_call();
    int  lib_constant();
    void lib_const(cHSymTable* tblp, int tblpos);
    int  formal_param_list();
    void func_call(int sym, int f_count);
    int  func_param_list(int f_count);
    void stat_asm();
    void stat_switch();
    string switch_block(string lb1, string fall_lb);
    void stat_while();
    void stat_do();
    void stat_for();
    void stat_if();
    void stat_return();
    void stat_break();
    void stat_continue();
    void expression();
    void simple_expression();
    void term();
    void factor();
    void ref_register(int sym);
    void array();
    void variable();
    void constant();
    int  const_exp();
    int  const_term();
    int  const_factor();
public:
    cParse();
    ~cParse();
    int parse(char *FileName, char *OutputFile);
};

#endif

