/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_scan.h     08/06/2012                                              */
/*  Copyright (C) 1998 - 2012 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/
#if !defined(_j3c_scan_h)
#define _j3c_scan_h

#include <iostream>
#include <fstream>
#include <string.h>
#include <stdlib.h>
#include "j3c_word.h"
#include "j3c_misc.h"

using namespace std;

class cScan {
    cWord ResWord;
    int  err;
    int  eof;
    char CurrentFileName[FILENAME_LEN];
    char LineBuf[LINEMAX];
    char CurrentLine[LINEMAX];
    char SourcePath[FILENAME_LEN];
    int  LineLen;
    int  LinePtr;
    int  LineCount;
    char nextch;
    int  num;
    int  sym;
    char Wd[LINEMAX];
    int  WdLen;
    ifstream fin;
    void error(const char* str);
    int  GetLine();
    char getch();
    void GetToken(char delim);
    inline int CheckAlfaNum();
    void GetIdentifier();
    void GetNumber();
  public:
    cScan();
    ~cScan();
    int   Num()   { return num; };
    char* Word()  { return Wd; };
    int   Len()   { return WdLen; };
    char* GetOpecodeName(int opc);
    char  GetChar(int idx) { return Wd[idx]; };
    int   GetLineCount() { return LineCount; };
    int   GetColumn()    { return LinePtr; };
    char* GetCurrentLine() { return CurrentLine; };
    const char* GetWordName(int sym);
    char* GetCurrentFileName() { return CurrentFileName; };

    int   getsym();
    int   OpenFile(char *FileName);
    void  CloseFile();
    void  SetPath(char *PathName) { strcpy(SourcePath, PathName);};
    char* GetPath() { return SourcePath; };
    void  DecodeSymbol(char* buffer, int sym);
};

#endif

