/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_stak.h       9/20/98                                               */
/*  Copyright (C) 1998,1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>        */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3c_stak_h)
#define _j3c_stak_h

class cStack {
    int* stack;
    int sp;
    int StackSize;
  public:
    cStack(int size) {
        sp = 0;
        stack = new int[size];
        StackSize = size;
    };
    ~cStack(){ delete [] stack; };
    void clear() { sp = 0; };
    void push(int i) {
        if (sp < StackSize) {
            stack[sp] = i;
            sp++;
        }
    };
    int  pop() {
        if (sp > 0) sp--;
        return stack[sp];
    };
    int  read() { return stack[sp-1]; };
};

#endif
