/*-------------------------------------------------------------------------*/
/*  J3W  3D Animation Kit  (compiler)                                      */
/*  j3c_sym.cpp        01/02/2006                                          */
/*  Copyright (C) 1998 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h>
#include <iostream>
#include <fstream>
#include <iomanip>
#include "j3c_sym.h"
#include "j3c_word.h"

using namespace std;

cSymTable::cSymTable(int table_size) :
          size(table_size), pos(0), addr(0), nest_level(0)
{
    SymTable = new Sym[table_size] ;
    Level = new cStack(32);
    Register("int"  , sym_TYPENAME,  0 );
}

cSymTable::~cSymTable() {
    delete [] SymTable;
}

int cSymTable::Register(const char *nm, const int k, const int  v)
{
    if (pos < size) {
        strcpy(SymTable[pos].name, nm);
        SymTable[pos].kind =  k;
        if ((k == sym_VARNAME) || (k == sym_ARRAYNAME)) {
            SymTable[pos].value = addr++;
        } else SymTable[pos].value = v;
        SymTable[pos].nest = nest_level;
        pos++;
        return pos - 1;
     } else return -1;
}

int cSymTable::GetNamePos(const char *nm, int &p)
{
    int found = 0;
    int i = pos - 1;

    while (!found && (i >= 0)) {
        if (!strcmp(SymTable[i].name, nm)) {
            p = i;
            found = 1;
        }
        i--;
    }
    return found;
}

int  cSymTable::Search(const char *nm,  int& k, int& v, int& n)
{
    int found;
    int i;

    found = GetNamePos(nm, i);
    if (found) {
        v = SymTable[i].value;
        k = SymTable[i].kind;
        n = SymTable[i].nest;
    }
    return found;
}

int  cSymTable::Check(const char *nm, int& k)
{
    int found;
    int i;

    found = GetNamePos(nm, i);
    if (found) k = SymTable[i].kind;
    return found;
}

void  cSymTable::GetValue(const int n, int& k, int& val, int& nest)
{
    if (n<pos) {
        k = SymTable[n].kind;
        val = SymTable[n].value;
        nest = SymTable[n].nest;
    }
}

int  cSymTable::SetValue(const int n, const int value)
{
    if (n<pos) {
        SymTable[n].value = value;
        return 1;
    }
    return 0;
}

void cSymTable::Reserve_Var_Area(int size)
{
    addr += size;
}

int cSymTable::Reserve_Cons_Area(int sz)
{
    if ((pos+sz) < size) {
        for (int i=0; i<sz; i++) {
            strcpy(SymTable[pos].name, "");
            SymTable[pos].kind =  sym_CONSTANT;
            SymTable[pos].value = 0;
            pos ++;
        }
        return 0;
     } else return -1;
}

void cSymTable::Delete(){
    pos = 0;
    Register("int"  , sym_TYPENAME,  0 );
}

void cSymTable::Enter(){
    Level->push(pos);
    nest_level++;
}

void cSymTable::Leave(){
    nest_level--;
    pos = Level->pop();
}

void cSymTable::PrintSymbols(){
    char kstr[20];

    for (int i=0; i<pos; i++) {
      cout << '(' << setw(3) << i << ")  ";
      cout << setw(32) << SymTable[i].name;
      switch (SymTable[i].kind) {
          case sym_CLASSNAME : strcpy(kstr, " class   "); break;
          case sym_VARNAME   : strcpy(kstr, " variable"); break;
          case sym_ARRAYNAME : strcpy(kstr, " array   "); break;
          case sym_PARAMNAME : strcpy(kstr, " parameter"); break;
          case sym_TYPENAME  : strcpy(kstr, " type    "); break;
          case sym_METHODNAME: strcpy(kstr, " method  "); break;
          case sym_STRING    : strcpy(kstr, " staring "); break;
          case sym_CONSTANT  : strcpy(kstr, " constant"); break;
      }
      cout << setw(8)  << kstr;
      cout << setw(8)  << SymTable[i].value ;
      cout << setw(8)  << SymTable[i].nest << '\n';
    }
}
