/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3p_sym.c      01/02/2006                                              */
/*  Copyright (C) 1998 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3c_sym_h)
#define _j3c_sym_h

#include "j3c_stak.h"

const int AL      = 64;

struct Sym {
    char name[AL];
    int  kind;
    int  value;
    int  nest;
};

class cSymTable {
    Sym*  SymTable;
    cStack* Level;
    int  status;
    int  size;
    int  pos;
    int  addr;
    int  nest_level;
  public:
    cSymTable(int table_size);
    ~cSymTable();
    int  GetNamePos(const char *nm, int &p);
    int  Register(const char *nm, const int k, const int  v);

    int  Search(const char *nm,  int& k, int& v, int& n);

    int  Check(const char *nm, int& k);
    void GetValue(const int n, int& k, int & val, int& nest);
    int  SetValue(const int n, const int value);
    int  GetNest() { return nest_level; };
    int  GetAddr() { return addr; }
    void SetAddr(int ad) { addr = ad; }
    void Reserve_Var_Area(int size);
    int  Reserve_Cons_Area(int sz);
    void Delete();
    void Enter();
    void Leave();
    void PrintSymbols();
};

#endif
