/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_symc.h      9/13/98                                                */
/*  Copyright (C) 1998,1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>        */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include "j3c_symc.h"

cClassTable::cClassTable(int table_size) : size(table_size), pos(0)
{
    ClassTable = new ClassSym[table_size] ;
}

cClassTable::~cClassTable() {
    delete [] ClassTable;
}

int cClassTable::Search(const char *nm, int p)
{
    for (int i=0; i<pos; i++) {
        if (!strcmp(ClassTable[i].name, nm)) {
            if (ClassTable[i].status == p) {
                return 1;
            }
        }
    }
    return 0;
}

void cClassTable::Register(const char *nm, int s)
{
    int found = Search(nm, s);
    if ((!found) && (pos < size)) {
        strcpy(ClassTable[pos].name, nm);
        ClassTable[pos].status =  s;
        pos++;
    }
}

int cClassTable::CheckClassIdent(const char *nm)
{
    return Search(nm, 1);
}

int cClassTable::CheckLibraryIdent(const char *nm)
{
    return Search(nm, 2);
}

int cClassTable::CheckFileIdent(const char *nm)
{
    return Search(nm, 0);
}

char* cClassTable::Check()
{
    for (int i=0; i<pos; i++)
        if (ClassTable[i].status == 0) return ClassTable[i].name;
    return 0;
}
