/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_symh.cpp    01/02/2006                                             */
/*  Copyright (C) 1998 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <string.h>
#include "j3c_symh.h"

cHSymTable::cHSymTable(int table_size)
   : cSymTable(table_size), parent(0)
{
}

void cHSymTable::set_parent(cHSymTable* p)
{
    parent = p;
}

void cHSymTable::set_classname(char *cname)
{
    strcpy(classname, cname);
}

char* cHSymTable::get_classname()
{
    return classname;
}

char* cHSymTable::SearchP(const char *nm, int& k, int& v, int& n)
{
    char* result = 0;
    int found;

    found = Search(nm, k, v, n);
    if (found) result = classname;
    if ((!found) && parent) {
        result = parent->SearchP(nm, k, v, n);
    }
    return result;
}

cHSymTable* cHSymTable::SearchT(const char *nm, int& pos)
{
    cHSymTable* result = 0;
    int found;

    found = GetNamePos(nm, pos);
    if (found) result = this;
    if ((!found) && parent) {
        result = parent->SearchT(nm, pos);
    }
    return result;
}
