/*-------------------------------------------------------------------------*/
/*  J3W   3D Animation Kit  (compiler)                                     */
/*  j3c_symr.h     01/02/2006                                              */
/*  Copyright (C) 1998 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3c_symr_h)
#define _j3c_symr_h

#include <string.h>
#include "j3c_symh.h"

class cSymRoot {
    cHSymTable**  SymTable;
    cHSymTable*   Current;
    int table_size;
    int p;

  public:
    cSymRoot(int t_size, int table_no) : table_size(t_size), p(0) {
        SymTable = new cHSymTable*[table_no];
    }
    ~cSymRoot() { delete [] SymTable; }

    void New(char *nm){
         SymTable[p] = new cHSymTable(table_size);
         Current = SymTable[p];
         Current->set_classname(nm);
         p++;
    };

    int  Register(const char *nm, const int k, const int  v)
         { return Current->Register(nm, k, v); } ;

    int  Search(const char *nm,  int& k, int & v, int& n)
         { return Current->Search(nm, k, v, n); };

    int  Check(const char *nm, int& k) { return Current->Check(nm, k); };

    void GetValue(const int n, int& k, int & val, int& nest)
         { Current->GetValue(n, k, val, nest); };

    int  SetValue(const int n, const int value)
         { return Current->SetValue(n, value); };

    int  GetNest() { return Current->GetNest(); };

    void Reserve_Var_Area(int size) { Current->Reserve_Var_Area(size); };

    int  Reserve_Cons_Area(int sz)
        { return Current->Reserve_Cons_Area(sz); };

    void Delete() { Current->Delete(); };

    void Enter() { Current->Enter(); };

    void Leave() { Current->Leave(); };

    void PrintSymbols() {
        for(int i=0; i<p; i++) SymTable[i]->PrintSymbols();
    };

    char* SearchP(const char *nm, int& k, int & v, int& n)
         { return Current->SearchP(nm, k, v, n); };

    cHSymTable* SearchT(const char *nm, int& pos)
         { return Current->SearchT(nm, pos); };

    void set_classname(char *cname){ Current->set_classname(cname); };

    char* get_classname() { return Current->get_classname(); };

    void set_parent(cHSymTable* p) {
        Current->set_parent(p);
        Current->SetAddr(p->GetAddr());
    };

    cHSymTable* SearchClass(const char* nm) {
         for(int i=0; i<p; i++)
             if (strcmp(nm,SymTable[i]->get_classname()) == 0)
                 return SymTable[i];
         return 0;
    };

    cHSymTable* SearchLibrary(const char* libname, char* methname,
                                  int &k, int & v, int& pos)
    {
         for(int i=0; i<p; i++)
             if (strcmp(libname, SymTable[i]->get_classname()) == 0) {
                 int n;
                 int found = SymTable[i]->GetNamePos(methname, pos);
                 if (found) {
                     SymTable[i]->GetValue(pos, k, v, n);
                     return SymTable[i];
                 } else return 0;
             }
         return 0;
    };
};

#endif
