/*-------------------------------------------------------------------------*/
/*  J3W  3D Animation Kit  (compiler)                                      */
/*  j3cp_word.h     08/06/2012                                             */
/*  Copyright (C) 2001-2012 Jun Mizutani <mizutani.jun@nifty.ne.jp>        */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3c_word_h)
#define _j3c_word_h

 const int sym_NIL          =   0;
 const int sym_LPAREN       =   1;
 const int sym_RPAREN       =   2;
 const int sym_LBRACK       =   3;
 const int sym_RBRACK       =   4;
 const int sym_LBRACE       =   5;
 const int sym_RBRACE       =   6;
 const int sym_COMMA        =   7;
 const int sym_COLON        =   8;
 const int sym_SEMI         =   9;
 const int sym_DOT          =  10;
 const int sym_EXCL         =  11;
 const int sym_PLUS         =  12;
 const int sym_MINUS        =  13;
 const int sym_MUL          =  14;
 const int sym_SLASH        =  15;
 const int sym_PERCENT      =  16;
 const int sym_BAR          =  17;
 const int sym_AMP          =  18;
 const int sym_RSHIFT       =  19;
 const int sym_LSHIFT       =  20;
 const int sym_2PLUS        =  21;
 const int sym_2MINUS       =  22;
 const int sym_EQUAL        =  23;
 const int sym_PCEQL        =  24;
 const int sym_AMPEQL       =  25;
 const int sym_MULEQL       =  26;
 const int sym_PLUSEQL      =  27;
 const int sym_MINUSEQL     =  28;
 const int sym_DIVEQL       =  29;
 const int sym_LSHIFTEQL    =  30;
 const int sym_RSHIFTEQL    =  31;
 const int sym_HATEQL       =  32;
 const int sym_BAREQL       =  33;
 const int sym_GTR          =  34;
 const int sym_LESS         =  35;
 const int sym_GTREQL       =  36;
 const int sym_LESSEQL      =  37;
 const int sym_2AMP         =  38;
 const int sym_2BAR         =  39;
 const int sym_2EQL         =  40;
 const int sym_EXEQL        =  41;
 const int sym_3GTR         =  42;
 const int sym_3GTREQL      =  43;
 const int sym_QUEST        =  44;
 const int sym_HAT          =  45;
 const int sym_TILDE        =  46;

 const int sym_BOOLEAN      = 100;
 const int sym_BYTE         = 101;
 const int sym_CHAR         = 102;
 const int sym_DOUBLE       = 103;
 const int sym_FLOAT        = 104;
 const int sym_INT          = 105;
 const int sym_LONG         = 106;
 const int sym_SHORT        = 107;
 const int sym_BREAK        = 108;
 const int sym_CONTINUE     = 109;
 const int sym_CASE         = 110;
 const int sym_DEFAULT      = 111;
 const int sym_DO           = 112;
 const int sym_ELSE         = 113;
 const int sym_FOR          = 114;
 const int sym_IF           = 115;
 const int sym_NEW          = 116;
 const int sym_RETURN       = 117;
 const int sym_SWITCH       = 118;
 const int sym_WHILE        = 119;
 const int sym_CLASS        = 120;
 const int sym_EXTENDS      = 121;
 const int sym_IMPLEMENTS   = 122;
 const int sym_IMPORT       = 123;
 const int sym_INTERFACE    = 124;
 const int sym_PACKAGE      = 125;
 const int sym_THROWS       = 126;
 const int sym_VOID         = 127;
 const int sym_CATCH        = 128;
 const int sym_FINALLY      = 129;
 const int sym_THROW        = 130;
 const int sym_TRY          = 131;
 const int sym_SUPER        = 132;
 const int sym_THIS         = 133;
 const int sym_ABSTRACT     = 134;
 const int sym_FINAL        = 135;
 const int sym_NATIVE       = 136;
 const int sym_PRIVATE      = 137;
 const int sym_PROTECTED    = 138;
 const int sym_PUBLIC       = 139;
 const int sym_STATIC       = 140;
 const int sym_SYNCHRONIZED = 141;
 const int sym_TRANSIENT    = 142;
 const int sym_VOLATILE     = 143;

 const int sym_LIBRARY      = 150;
 const int sym_ASM          = 151;

 const int sym_EOF          = 200;
 const int sym_IDENT        = 201;
 const int sym_NUMBER       = 202;
 const int sym_CHARACTER    = 203;
 const int sym_STRING       = 204;
 const int sym_CLASSNAME    = 205;
 const int sym_LIBNAME      = 206;
 const int sym_VARNAME      = 207;
 const int sym_TYPENAME     = 208;
 const int sym_METHODNAME   = 209;
 const int sym_CONSTANT     = 210;
 const int sym_ERROR        = 211;
 const int sym_PARAMNAME    = 212;
 const int sym_LOCALNAME    = 213;
 const int sym_ARRAYNAME    = 214;

 const int sym_RQ           = 300;
 const int sym_RL           = 301;
 const int sym_RX           = 302;
 const int sym_RY           = 303;
 const int sym_RZ           = 304;
 const int sym_RH           = 305;
 const int sym_RP           = 306;
 const int sym_RB           = 307;
 const int sym_R1           = 308;
 const int sym_R2           = 309;
 const int sym_R3           = 310;
 const int sym_R4           = 311;
 const int sym_R5           = 312;
 const int sym_R6           = 313;

 const int  NOOP   = 0x1000;
 const int  THROW  = 0x1001;
 const int  INC    = 0x1008;
 const int  DEC    = 0x1009;
 const int  ADD    = 0x1010;
 const int  SUB    = 0x1011;
 const int  MUL    = 0x1012;
 const int  DIV    = 0x1013;
 const int  SHL    = 0x1014;
 const int  SHR    = 0x1015;
 const int  AND    = 0x1016;
 const int  OR     = 0x1017;
 const int  NOT    = 0x1018;
 const int  CMP    = 0x1019;
 const int  NEG    = 0x101A;
 const int  SQRT   = 0x101B;
 const int  SIN    = 0x101C;
 const int  COS    = 0x101D;
 const int  ATAN   = 0x101E;
 const int  RANDOM = 0x101F;
 const int  BRA    = 0x1020;
 const int  BEQ    = 0x1021;
 const int  BNE    = 0x1022;
 const int  BGR    = 0x1023;
 const int  BGE    = 0x1024;
 const int  BLS    = 0x1025;
 const int  BLE    = 0x1026;
 const int  BMI    = 0x1027;
 const int  BPL    = 0x1028;
 const int  LOOP   = 0x1029;
 const int  CALL   = 0x1030;
 const int  RETURN = 0x1031;
 const int  PUSH   = 0x1032;
 const int  POP    = 0x1033;
 const int  CLEARA = 0x1034;
 const int  PUSHA  = 0x1035;
 const int  POPA   = 0x1036;
 const int  CLEARG = 0x1037;
 const int  PUSHG  = 0x1038;
 const int  POPG   = 0x1039;
 const int  ENTER  = 0x103A;
 const int  LEAVE  = 0x103B;
 const int  CALLTB = 0x103C;
 const int  LOAD   = 0x1040;
 const int  LOADM  = 0x1041;
 const int  XLOAD  = 0x1042;
 const int  CLOAD  = 0x1043;
 const int  LOADBP = 0x1044;
 const int  PNTUV  = 0x1046;
 const int  DEFPUV = 0x1047;
 const int  TXFILE = 0x1048;
 const int  TXSET  = 0x1049;
 const int  TXAXIS = 0x104A;
 const int  TXALPH = 0x104B;
 const int  TXSCAL = 0x104C;
 const int  TXCHG  = 0x104D;
 const int  TXMAP  = 0x104E;
 const int  TXBIAS = 0x104F;
 const int  STORE  = 0x1050;
 const int  XSTORE = 0x1051;
 const int  CSTORE = 0x1052;
 const int  STORBP = 0x1054;
 const int  GENPRC = 0x1060;
 const int  DELPRC = 0x1061;
 const int  WAIT   = 0x1062;
 const int  STPALL = 0x1063;
 const int  SEND   = 0x1064;
 const int  RECEIV = 0x1065;
 const int  SENDTO = 0x1066;
 const int  CHILD  = 0x1067;
 const int  GRAPHM = 0x1080;
 const int  TEXTM  = 0x1081;
 const int  BCOLOR = 0x1082;
 const int  ZOOM   = 0x1083;
 const int  WIRE   = 0x1084;
 const int  NEAR   = 0x1085;
 const int  FAR    = 0x1086;
 const int  EMIT   = 0x1088;
 const int  PARALL = 0x1089;
 const int  INKEY  = 0x1090;
 const int  RAWKEY = 0x1091;
 const int  MOUSE  = 0x1092;
 const int  OUTNUM = 0x1098;
 const int  OUTCHR = 0x1099;
 const int  OUTSTM = 0x109A;
 const int  OUTSTR = 0x109B;
 const int  NOTE   = 0x109C;
 const int  MIDI   = 0x109D;
 const int  MOVF   = 0x10A0;
 const int  MOVB   = 0x10A1;
 const int  MOVL   = 0x10A2;
 const int  MOVR   = 0x10A3;
 const int  MOVU   = 0x10A4;
 const int  MOVD   = 0x10A5;
 const int  ROTH   = 0x10A6;
 const int  ROTP   = 0x10A7;
 const int  ROTB   = 0x10A8;
 const int  MOVALL = 0x10B0;
 const int  MOVALH = 0x10B1;
 const int  SCALE  = 0x10B2;
 const int  SETGRV = 0x10B8;
 const int  GETGRV = 0x10B9;
 const int  SETACL = 0x10BA;
 const int  GETACL = 0x10BB;
 const int  SETVEL = 0x10BC;
 const int  GETVEL = 0x10BD;
 const int  SETWVL = 0x10BE;
 const int  GETWVL = 0x10BF;
 const int  GENOBJ = 0x10C0;
 const int  DEFPNT = 0x10C1;
 const int  DEFPLN = 0x10C2;
 const int  DELOBJ = 0x10C3;
 const int  SETEYE = 0x10C4;
 const int  POINT  = 0x10C5;
 const int  SETREF = 0x10C6;
 const int  SETAMB = 0x10C7;
 const int  EYEORG = 0x10C8;
 const int  GETVXN = 0x10C9;
 const int  PLANE  = 0x10CA;
 const int  TRANSP = 0x10CB;
 const int  UPDTVP = 0x10CC;
 const int  RSETVP = 0x10CD;
 const int  SLIDE  = 0x10CE;
 const int  HOME   = 0x10CF;
 const int  GETPOS = 0x10D0;
 const int  SETPOS = 0x10D1;
 const int  PRCPOS = 0x10D2;
 const int  DISTNC = 0x10D3;
 const int  PRIOR  = 0x10D4;
 const int  RELATV = 0x10D5;
 const int  LOOK   = 0x10D6;
 const int  RELAT2 = 0x10D7;
 const int  FINDVX = 0x10D8;
 const int  SETVTX = 0x10D9;
 const int  GETVTX = 0x10DA;
 const int  SETPLN = 0x10DB;
 const int  GETPLN = 0x10DC;
 const int  SETSCL = 0x10DD;
 const int  GETSCL = 0x10DE;
 const int  GRNUM  = 0x10E0;
 const int  GRCHR  = 0x10E1;
 const int  GRSTM  = 0x10E2;
 const int  GRSTR  = 0x10E3;
 const int  GRCOL  = 0x10E4;
 const int  GRCLR  = 0x10E5;
 const int  GRCSR  = 0x10E6;
 const int  GRPOS  = 0x10E7;
 const int  GRLINE = 0x10E8;
 const int  GRLINC = 0x10E9;
 const int  SYSTIM = 0x10F0;
 const int  SYSCNT = 0x10F1;
 const int  SYSPRC = 0x10F2;
 const int  DATA   = 0x10F3;
 const int  WRITE  = 0x10F4;
 const int  READ   = 0x10F5;
 const int  LIGHT  = 0x10F6;
 const int  READPL = 0x10F8;
 const int  COLNUM = 0x10F9;
 const int  COLWDT = 0x10FA;
 const int  CNTVTX = 0x10FB;
 const int  CNTPLY = 0x10FC;
 const int  SETCOL = 0x10FD;
 const int  RSTCOL = 0x10FE;
 const int  VER    = 0x10FF;
 const int  DEFINE = 0x1100;

class cWord {
  public:
    int   CheckResWord(const char * Wd, int &sym);
    const char* GetResWordName(int sym);
    int   CheckOpeCode(const char * Wd, int &opc);
    const char* GetOpecodeName(int opc);
    int   CheckRegName(const char * Wd, int &sym);
};

#endif
