/*-------------------------------------------------------------------------*/
/*  J3W ver 6.51  3D Animation Kit  (assembler)                            */
/*  j3dasm.cpp    08/06/2012                                               */
/*  Copyright (C) 1996 - 2012 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <iostream>
#include <string>
#include "jrlcode.h"
#include "jrlasm.h"

using namespace std;

const char* VersionStr = " j3dasm  ver. 1.49  2012 Jun Mizutani \n";
const int MAX_CODE = 1048576;    /* 4MB */

cCode code(MAX_CODE);
cAssembler assembler(&code);

void usage() {
    cerr << VersionStr;
    cerr <<"usage : j3dasm filename\n";
    cerr <<"        j3dasm - filename\n";
}

int main(int argc, char* argv[]) {
    char SourceFileName[128];
    char ObjectFileName[128];

    if (argc>1) {
        if (strcmp(argv[1], "-") == 0) {
            if ((argc==3) && (*argv[2]!='-')) {
                strncpy(SourceFileName, argv[2], 127);
                assembler.assemble(SourceFileName);
                code.SaveObjFile("");  /* to standard outout */
            } else
                usage();
        } else if ((argc==2) && (*argv[1]!='-')) {
            cout << VersionStr;
            strncpy(SourceFileName, argv[1], 127);
            cout << "     Source File : " << SourceFileName << '\n';
            int i = strlen(SourceFileName);
            while ((SourceFileName[i] != '.')&&(i >= 0)) i--; /* discard extention */
            if (i > 0) {
                for(int j=0; j<=i; j++)
                    ObjectFileName[j]=SourceFileName[j];
                ObjectFileName[i] = 0;
                strcat(ObjectFileName, ".j3d");
            }
            cout << "     Object File : " << ObjectFileName << '\n';
            if (argc>1) assembler.assemble(SourceFileName);
            code.SaveObjFile(ObjectFileName);
            cout << "     Assemble " << code.Pos() << " steps\n";
        } else
            usage();
    } else
        usage();
    return 0;
}
