/*-------------------------------------------------------------------------*/
/*  J3W ver 6.51  3D Animation Kit  (assembler)                            */
/*  jrlasm.h      01/02/2006                                               */
/*  Copyright (C) 1995 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_jrlasm_h)
#define _jrlasm_h

#include <string.h>
#include "jrlscan.h"
#include "jrlcode.h"
#include "jrlsym.h"

class cAssembler {
    cScan scan;
    cCode *pCode;
    void asm_error(int eno);
    void ShowType(cScan &scan, int type);
    int  SetOpcode(unsigned int opc) { return (unsigned int )opc << 24; };
    int  SetReg1(unsigned int  cod, unsigned int reg) {
            return cod | ((unsigned int )reg << 16); };
    int  SetReg2(unsigned int  cod, unsigned int reg) {
            return cod | ((unsigned int )reg << 20); };
    int  SetParam16(unsigned int  cod, unsigned int param16) {
        return cod | ((unsigned int )param16 & 0xFFFF); };
    int  SetParam24(unsigned int  cod, unsigned int param24) {
        return cod | ((unsigned int )param24 & 0xFFFFFF); };
    int asm_line(int op, int pass);
  public:
    cAssembler(cCode *cd);
    int assemble(char *SourceFileName);
};

#endif
