/*-------------------------------------------------------------------------*/
/*  J3W ver 4.50z  3D Animation Kit                                        */
/*  jrlcode.cpp    01/08/2008                                              */
/*  Copyright (C) 1995 - 2008 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <iostream>
#include <fstream>
#include <string.h>
#include "jrlcode.h"

#ifdef WINGUI
#  include "console.h"
#endif

using namespace std;

void cCode::clear_code()
{
    endpos = 0;
    for(int i=0;i<codeSize;i++) code[i]=0;
}

int cCode::LoadObjFile(char *FileName)
{
    if (strlen(FileName) == 0) {
        int  n;
        while(cin >> hex >> n) set_code(n);
    } else {
        setlocale(LC_ALL, "");
        ifstream source;
        source.open(FileName);

        if (!source) {
#ifdef WINGUI
           cs->writeLn();
           cs->write("Cannot open source file ");
           cs->write(FileName);
           cs->write(" for input");
           cs->writeLn();
#else
           cerr << "Cannot open source file " << FileName << " for input\n";
#endif
           return 1;
        }

        unsigned int  n;
        while(source >> hex >> n) set_code(n);

        source.close();
    }
/*  20060305 OK
    char tmp[255];
    _ltoa(endpos, tmp, 10);
    MessageBox(NULL, tmp, "Size", MB_OK);
*/
    if ((endpos) && (endpos < codeSize )) return 0;
    else return 1;
}

int cCode::SaveObjFile(char *FileName)
{
    if (strlen(FileName) == 0) {
        for(int i=0; i<endpos; i++)
        cout << hex << code[i] << '\n';
    } else {
        setlocale(LC_ALL, "");
        ofstream dest;
        dest.open(FileName);

        if (!dest) {
           cerr << "Cannot open destination file " << FileName << " for output\n";
           return 1;
        }

        for(int i=0; i<endpos; i++)
          dest << hex << (unsigned int)code[i] << '\n';
        dest.close();
    }
    return 0;
}

