/*-------------------------------------------------------------------------*/
/*  J3W ver 6.51  3D Animation Kit                                         */
/*  jrlcode.h     01/04/2006                                               */
/*  Copyright (C) 1995 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_jrlcode_h)
#define _jrlcode_h

#ifdef FREEBSD
#include <sys/types.h>
#endif

#ifdef AIX
#include <sys/machine.h>
#endif

#ifdef LINUX
#include <endian.h>
#endif

#ifdef SOLARIS
#include <sys/types.h>
#ifdef _BIG_ENDIAN
#define BIG_ENDIAN 4321
#define BYTE_ORDER BIG_ENDIAN
#else
#define LITTLE_ENDIAN 1234
#define BYTE_ORDER LITTLE_ENDIAN
#endif
#endif

class cCode {
    int  * code;
    int codeSize;
    int endpos;
#if BYTE_ORDER == BIG_ENDIAN
    char s[128];
#endif

  public:
    cCode(int size) : codeSize(size), endpos(0) {
        code = new int  [codeSize];
    };
    ~cCode() { delete [] code; };
    int  LoadObjFile(char* FileName);
    int  SaveObjFile(char* FileName);
    int  Size() { return codeSize; }
    int  Pos() { return endpos; }
    int  fetch(const int p) { return code[p] ; }
    char* GetStr(int p) {
#if BYTE_ORDER == BIG_ENDIAN
        int i = -1;
        do {
            i++;
            s[i] = char(code[p + i/4] >> (8 * (i%4)));
        } while (s[i]!=0);
        return s;
#else
        return (char*)(&code[p]) ;
#endif
    }
    void set_code_at(const int p, const int  n) { code[p] = n; }
    void set_code(const int  n) { if (endpos < codeSize) code[endpos++] = n; }
    void clear_code();
};

#endif

