/*-------------------------------------------------------------------------*/
/*  J3W ver 5.60  3D Animation Kit  (assembler)                            */
/*  jrlscan.h     10/27/2008                                               */
/*  Copyright (C) 1996 -2008 Jun Mizutani <mizutani.jun@nifty.ne.jp>       */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_jrlscan_h)
#define _jrlscan_h

#include <iostream>
#include <fstream>
#include <string.h>
#include <stdlib.h>
#include "jrlsym.h"

using namespace std;

 const int INC_NEST = 9;
 const int FILENAME_LEN = 128;
 const int LINEMAX = 256;
 const int W_NULL   = 0;
 const int W_CHAR   = 1;
 const int W_STRING = 2;
 const int W_SYM    = 3;
 const int W_NUM    = 4;
 const int W_REG    = 5;
 const int W_LABEL  = 6;
 const int W_OP     = 7;
 const int W_DATA   = 8;
 const int W_EOL    = 0x200;
 const int W_EOF    = 0x400;

 const int  NOOP   = 0x00;
 const int  THROW  = 0x01;
 const int  INC    = 0x08;
 const int  DEC    = 0x09;
 const int  ADD    = 0x10;
 const int  SUB    = 0x11;
 const int  MUL    = 0x12;
 const int  DIV    = 0x13;
 const int  SHL    = 0x14;
 const int  SHR    = 0x15;
 const int  AND    = 0x16;
 const int  OR     = 0x17;
 const int  NOT    = 0x18;
 const int  CMP    = 0x19;
 const int  NEG    = 0x1A;
 const int  SQRT   = 0x1B;
 const int  SIN    = 0x1C;
 const int  COS    = 0x1D;
 const int  ATAN   = 0x1E;
 const int  RANDOM = 0x1F;
 const int  BRA    = 0x20;
 const int  BEQ    = 0x21;
 const int  BNE    = 0x22;
 const int  BGR    = 0x23;
 const int  BGE    = 0x24;
 const int  BLS    = 0x25;
 const int  BLE    = 0x26;
 const int  BMI    = 0x27;
 const int  BPL    = 0x28;
 const int  LOOP   = 0x29;
 const int  CALL   = 0x30;
 const int  RETURN = 0x31;
 const int  PUSH   = 0x32;
 const int  POP    = 0x33;
 const int  CLEARA = 0x34;
 const int  PUSHA  = 0x35;
 const int  POPA   = 0x36;
 const int  CLEARG = 0x37;
 const int  PUSHG  = 0x38;
 const int  POPG   = 0x39;
 const int  ENTER  = 0x3A;
 const int  LEAVE  = 0x3B;
 const int  CALLTB = 0x3C;
 const int  LOAD   = 0x40;
 const int  LOADM  = 0x41;
 const int  XLOAD  = 0x42;
 const int  CLOAD  = 0x43;
 const int  LOADBP = 0x44;
 const int  PNTUV  = 0x46;
 const int  DEFPUV = 0x47;
 const int  TXFILE = 0x48;
 const int  TXSET  = 0x49;
 const int  TXAXIS = 0x4A;
 const int  TXALPH = 0x4B;
 const int  TXSCAL = 0x4C;
 const int  TXCHG  = 0x4D;
 const int  TXMAP  = 0x4E;
 const int  TXBIAS = 0x4F;
 const int  STORE  = 0x50;
 const int  XSTORE = 0x51;
 const int  CSTORE = 0x52;
 const int  STORBP = 0x54;
 const int  GENPRC = 0x60;
 const int  DELPRC = 0x61;
 const int  WAIT   = 0x62;
 const int  STPALL = 0x63;
 const int  SEND   = 0x64;
 const int  RECEIV = 0x65;
 const int  SENDTO = 0x66;
 const int  CHILD  = 0x67;
 const int  GRAPHM = 0x80;
 const int  TEXTM  = 0x81;
 const int  BCOLOR = 0x82;
 const int  ZOOM   = 0x83;
 const int  WIRE   = 0x84;
 const int  NEAR   = 0x85;
 const int  FAR    = 0x86;
 const int  EMIT   = 0x88;
 const int  PARALL = 0x89;
 const int  INKEY  = 0x90;
 const int  RAWKEY = 0x91;
 const int  MOUSE  = 0x92;
 const int  OUTNUM = 0x98;
 const int  OUTCHR = 0x99;
 const int  OUTSTM = 0x9A;
 const int  OUTSTR = 0x9B;
 const int  NOTE   = 0x9C;
 const int  MIDI   = 0x9D;
 const int  MOVF   = 0xA0;
 const int  MOVB   = 0xA1;
 const int  MOVL   = 0xA2;
 const int  MOVR   = 0xA3;
 const int  MOVU   = 0xA4;
 const int  MOVD   = 0xA5;
 const int  ROTH   = 0xA6;
 const int  ROTP   = 0xA7;
 const int  ROTB   = 0xA8;
 const int  MOVALL = 0xB0;
 const int  MOVALH = 0xB1;
 const int  SCALE  = 0xB2;
 const int  SETGRV = 0xB8;
 const int  GETGRV = 0xB9;
 const int  SETACL = 0xBA;
 const int  GETACL = 0xBB;
 const int  SETVEL = 0xBC;
 const int  GETVEL = 0xBD;
 const int  SETWVL = 0xBE;
 const int  GETWVL = 0xBF;
 const int  GENOBJ = 0xC0;
 const int  DEFPNT = 0xC1;
 const int  DEFPLN = 0xC2;
 const int  DELOBJ = 0xC3;
 const int  SETEYE = 0xC4;
 const int  POINT  = 0xC5;
 const int  SETREF = 0xC6;
 const int  SETAMB = 0xC7;
 const int  EYEORG = 0xC8;
 const int  GETVXN = 0xC9;
 const int  PLANE  = 0xCA;
 const int  TRANSP = 0xCB;
 const int  UPDTVP = 0xCC;
 const int  RSETVP = 0xCD;
 const int  SLIDE  = 0xCE;
 const int  HOME   = 0xCF;
 const int  GETPOS = 0xD0;
 const int  SETPOS = 0xD1;
 const int  PRCPOS = 0xD2;
 const int  DISTNC = 0xD3;
 const int  PRIOR  = 0xD4;
 const int  RELATV = 0xD5;
 const int  LOOK   = 0xD6;
 const int  RELAT2 = 0xD7;
 const int  FINDVX = 0xD8;
 const int  SETVTX = 0xD9;
 const int  GETVTX = 0xDA;
 const int  SETPLN = 0xDB;
 const int  GETPLN = 0xDC;
 const int  SETSCL = 0xDD;
 const int  GETSCL = 0xDE;
 const int  GRNUM  = 0xE0;
 const int  GRCHR  = 0xE1;
 const int  GRSTM  = 0xE2;
 const int  GRSTR  = 0xE3;
 const int  GRCOL  = 0xE4;
 const int  GRCLR  = 0xE5;
 const int  GRCSR  = 0xE6;
 const int  GRPOS  = 0xE7;
 const int  GRLINE = 0xE8;
 const int  GRLINC = 0xE9;
 const int  SYSTIM = 0xF0;
 const int  SYSCNT = 0xF1;
 const int  SYSPRC = 0xF2;
 const int  DATA   = 0xF3;
 const int  WRITE  = 0xF4;
 const int  READ   = 0xF5;
 const int  LIGHT  = 0xF6;
 const int  READPL = 0xF8;
 const int  COLNUM = 0xF9;
 const int  COLWDT = 0xFA;
 const int  CNTVTX = 0xFB;
 const int  CNTPLY = 0xFC;
 const int  SETCOL = 0xFD;
 const int  RSTCOL = 0xFE;
 const int  VER    = 0xFF;
 const int  DEFINE = 0x100;

class cScan {
    char IncFileName[INC_NEST][FILENAME_LEN];

    int  IncLineNumber[INC_NEST];
    char CurrentFileName[FILENAME_LEN];
    int  IncNest;
    char LineBuf[LINEMAX];
    char CurrentLine[LINEMAX];
    int  LineLen;
    int  LinePtr;
    int  LineCount;
    int  CurrentLineCount;
    char Wd[LINEMAX];
    int  WdLen;
    int  WNum;
    ifstream fin[INC_NEST];
    int  GetLine();
    int  CheckRegName();
    int  CheckOpeCode(int  &opc);
    char SourcePath[FILENAME_LEN];
    int  std_in;
  public:
    cScan();
    ~cScan();
    cSymTable *SymTable;
    int   NextWord();
    int   Num()   { return WNum; };
    char* Word()  { return Wd; };
    int   Len()   { return WdLen; };
    const char* GetOpecodeName(int opc);
    char  GetChar(int idx) { return Wd[idx]; };
    int   GetLineCount() { return CurrentLineCount; };

    char* GetCurrentLine() { return CurrentLine; };
    char* GetCurrentFileName() { return CurrentFileName; };

    int   OpenFile(char *FileName);
    void  SetPath(char *PathName) { strcpy(SourcePath, PathName);}
};

#endif

