/*-------------------------------------------------------------------------*/
/*  J3W ver 6.51  3D Animation Kit  (assembler)                            */
/*  jrlsym.cpp    01/02/2006                                               */
/*  Copyright (C) 1995 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h>
#include "jrlsym.h"

using namespace std;

cSymTable::cSymTable(int table_size) : size(table_size), pos(0) {
    SymTable = new Sym[table_size] ;
}

cSymTable::~cSymTable() {
    delete [] SymTable;
}

int cSymTable::RegistSymName(const char *nm, const int  val, const int st) {
    if (pos < size) {
        strcpy(SymTable[pos].name, nm);
        SymTable[pos].value = val;
        SymTable[pos].status = st;
        pos++;
        return 1;
     } else return 0;
}

int cSymTable::GetNamePos(const char *nm, int &p) {
    int found = 0;
    int i = 0;

    while ((!found) && (i < pos)) {
        if (!strcmp(SymTable[i].name, nm)) {
            p = i;
            found = 1;
        }
        i++;
    }
    return found;
}

int cSymTable::SearchSymName(const char *nm, int& val, int &st) {
    int found;
    int i;

    found = GetNamePos(nm, i);
    if (found) {
        val = SymTable[i].value;
        st  = SymTable[i].status;
    }
    return found;
}

int cSymTable::CheckSymName(const char *nm, int& st) {
    int found;
    int i;

    found = GetNamePos(nm, i);
    if (found) st = SymTable[i].status;
    return found;
}

