/*-------------------------------------------------------------------------*/
/*  J3W ver 6.51  3D Animation Kit  (assembler)                            */
/*  jrlsym.h      01/02/2006                                               */
/*  Copyright (C) 1995 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_jrlsym_h)
#define _jrlsym_h

const int S_NULL      = 0;
const int S_REF       = 1;
const int S_DATA_ADDR = 2;
const int S_CODE_ADDR = 3;
const int S_SYMBOL    = 4;

struct Sym {
    char name[32];
    int  value;
    int  status;
};

class cSymTable {
    Sym*  SymTable;
    int  status;
    int  size;
    int  pos;
    int GetNamePos(const char *nm, int &p);
  public:
    cSymTable(int table_size);
    ~cSymTable();
    int  RegistSymName(const char *nm, const int  val, const int st);

    int  SearchSymName(const char *nm, int & val, int &st);

    int  CheckSymName(const char *nm, int& st);
};

#endif
