/*-------------------------------------------------------------------------*/
/*  J3W ver 6.50  3D Animation Kit                                         */
/*  axis.h        01/02/2006                                               */
/*  Copyright (C) 1996 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_axis_h)
#define _axis_h

#include "misc3d.h"

class TAxis {
    int     change;
    Vector  origin;
    Matrix3      m;
    Quaternion   q;

    void SetAngle(int  h, int  p, int  b);
    void GetAngle(int  &h, int  &p, int  &b);
    void EulerAngle(int  DH, int  DP, int  DB);

  public:
    TAxis();
    void reset_change() { change = 0; };
    void move(Vector v);

    void rotate(int  h, int  p, int  b);

    void set_origin(int  x, int  y, int  z);

    Vector get_origin();

    Matrix3 get_matrix();
    void    set_matrix(Matrix3 tm);
    Quaternion get_quat();
    Vector RelativePosition(Vector v);

    void attitude(int  h, int  p, int  b);

    void get_attitude(int  &h, int  &p, int  &b);

    void CalcRotationMatrix();

    int  CheckShortestPath(const Quaternion &q1, const Quaternion &q2);

    void attitudeq(Quaternion qq);

};

#endif
