/*-------------------------------------------------------------------------*/
/*  J3W ver 6.50  3D Animation Kit                                         */
/*  j3djob.h      01/02/2006                                               */
/*  Copyright (C) 1995 - 2006  Jun Mizutani <mizutani.jun@nifty.ne.jp>     */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3djob_h)
#define _j3djob_h

#include  "jrlcode.h"
#include  "j3dproc.h"
#include  "spaceh3d.h"
#include  "hobj3d.h"
#include  "screen.h"
#include  "misc3d.h"
#include  "timing.h"

const int MAXCOMMON = 30000;
const int MAXLINES  = 100;
const int MAX_STRING = 2000;

typedef struct Line2D {
    Vector2D p0, p1;
    int color;
    int stat;
};

class TJob {
    cCode     Code;
    int       hMidi;
    int       numProc;
    int       Count;
    int       maxProc;
    int       current_process;
    TProcess  **process;
    cTiming   aTimer;
    int       last_time;
    int       *CommonMem;
    TSpaceH3D *pSpace;
    TScreen   *pScreen;
    char      ScreenString[MAX_STRING+1];
    int       StrColor;
    int       StrStat;
    int       Cursor;
    Line2D    GrLines[MAXLINES];
    int       InKey;
    int       MouseX, MouseY;
    int       MouseShift;
    int       g_mode;
    int       MidiInUse;
    int       throttle_flag;
    char      ObjectPath[128];
    void  common_func(int  delta);
  public:
    TJob(int code_size, int max_proc, TSpaceH3D *p_space,
                       TScreen *sc);
    ~TJob();
    int  LoadObjFile(char* FileName);
    int  SaveObjFile(char* FileName);
    int count_process(){ return numProc;}
    int new_process(int maxData, int StartPos, int on, int  *reg);

    void delete_process(int i);
    void SendMessage(int id, int  msg);
    void SendMessageTo(int pno, int  msg);
    THObj3D *GetObject(int id);
    int  job_scheduler();
    void SetEye(THObj3D *eye);
    void SetGraph();
    void SetMode(int m);
    void ResetGraph();
    int  GetCount(){return Count;}
    void StartTimer();
    int  GetTime();
    int  GetCurProc(){ return  current_process;}

    void SetBackGroundColor(int bg);
    void SetZoom(int angle);
    int  Distance(THObj3D* obj1, int id, int  &pno, int  &cnt);

    void RelativePosition(THObj3D* obj1, int id, int  *reg);

    int  Look(THObj3D* obj1, int id, int  &head, int  &pitch);

    int  GetCommonMem(int i) { return CommonMem[i]; }

    void SetCommonMem(int i, int  val) {
             if ((i<MAXCOMMON) && (i>=0))
                 CommonMem[i] = val;
    }
    int  NearestVertex(int  x, int  y, int  z,int  id, int  &nvertex);
    int  WriteCommon(char *filename, int  Pos, int  Size);

    int  ReadCommon(char *filename, int  Pos);

    void SetCursorPosition(int pos);
    int  GetCursorPosition(){ return  Cursor;}
    void StringColor(int col);
    void WriteString(char *str);
    void ClearString();
    void GrLine(int n, Vector2D pa, Vector2D pb, int color);
    void GrLineClear(int n);
    void SetKey(int Key);
    int  GetKey();
    void SetMouse(int X, int Y, int Shift);
    void GetMouse(int  &X, int  &Y, int  &Z);

#ifdef MIDI_SUPPORT
    void MidiOpen();
    void Midi(int MidiEvent, int  MidiMes);
#endif
    char *Path() { return ObjectPath;}
    void Color(int  no, int  dr, int  dg, int  db, int  ar, int  ag, int  ab);
    void ColorReset();
    void Light(int intensity, int x, int y, int z, int dx, int dy, int dz);
    void SetLightObject(THObj3D * pObj, int emit);

    void SetLightType(int parallel);
    void Throttle(int  value);
};

#endif
