/*-------------------------------------------------------------------------*/
/*  J3W ver 6.50  3D Animation Kit                                         */
/*  j3dproc.h     01/02/2006                                               */
/*  Copyright (C) 1995 - 2006  Jun Mizutani <mizutani.jun@nifty.ne.jp>     */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3dproc_h)
#define _j3dproc_h

#include  "jrlcode.h"
#include  "spaceh3d.h"
#include  "hobj3d.h"

const int RQ   =  1 ;
const int RL   =  2 ;
const int RX   =  3 ;
const int RY   =  4 ;
const int RZ   =  5 ;
const int RH   =  6 ;
const int RP   =  7 ;
const int RB   =  8 ;
const int R1   =  9 ;
const int R2   = 10 ;
const int R3   = 11 ;
const int R4   = 12 ;
const int R5   = 13 ;
const int R6   = 14 ;

const int f_ZERO  = 1 ;
const int f_MINUS = 2 ;

const int M_STOP   = 0x7FFFFFFF ;
const int M_THROW  = 0x7FFFFFFE ;
const int PROC_ALL = 0x7FFF;

typedef short WORD;

class TJob;
class TProcess {
    int  pc;
    int  sp;
    int  fl;
    int  bp;
    int  aMessage;
    cCode     *pCode;
    TJob      *pJob;
    TSpaceH3D *pSpace;
    THObj3D   *pObj;
    int  ObjNo;
    int  Reg[16];
    int  * DataMem;
    int  maxDataMem;
    int  rest_time;
    int  rest_param;
    int  total_time;
    int  total_x, total_y, total_z;
    int  total_h, total_p, total_b;
    int  inst_grp;
    int  inst_type;
    int  reg1, reg2;
    short param16;
    int  offset;
    Quaternion qa, qb, dq;
    int  fnew;
    int  fwait;

    void GetOperand();
    int  AdjustParam(int  &delta, int  &r_param);

    int  MoveInst(WORD inst_type, int   param);
    int CheckError(int err);
    int execute(int  &delta);
    void RelativePos2(THObj3D *pobj1,
                     int  &x,int  &y,int  &z,int  &h,int  &p,int  &b);
  public:
    TProcess(TJob* jp, int maxData, int StartPos,
                         cCode* code_ptr, TSpaceH3D* p_space,
                         const int  *_reg, const int on);
    ~TProcess();
    int GetID() { return  Reg[RQ]; }
    int GetObjNo(){ return ObjNo; }
    THObj3D *GetObject() { return  pObj;}
    int   GetMessage() { return  aMessage;}
    void  SetMessage(int  msg){ aMessage = msg;}
    int   Run(int  delta);
    void  set_new(int n){ fnew = n; };
    int   get_new() {return fnew; };
};

#endif

