/*-------------------------------------------------------------------------*/
/*  J3W ver 6.50  3D Animation Kit                                         */
/*  j3w.cpp       01/02/2006                                               */
/*  Copyright (C) 1996 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include <iostream>
#include <string.h>
#include <new>
#include <stdlib.h>
#include <signal.h>
#include "j3wunit.h"

using namespace std;

void my_handler() {
    cout << " Cannot allocate memory \n";
    abort();
}

void my_signal_handler(int i) {
    cbreak();
    echo();
    exit(0);
}

int main(int argc, char* argv[])
{
    char ObjectFileName[80];

    J3WCreate();
    J3WOpen(0,0,0,0);
    if (argc > 1) {
        set_new_handler(my_handler);
        signal(SIGINT, my_signal_handler);
        signal(SIGQUIT, my_signal_handler);
        if (strcmp(argv[1],"-f")==0) {
          if (strcmp(argv[2],"-")==0) strcpy(ObjectFileName,"");
          else strcpy(ObjectFileName,argv[2]);
          if (J3WNew(ObjectFileName) == 0) {
              cout << '\n' << " File not found or too big" << '\n';
              J3WClose();
              return 0;
          }
          cout << " Execute file : " << argv[2] << '\n';
          J3WOption(0);
          J3WStart();
          while (J3WLoop() == 0) ;
        } else {
          if (strcmp(argv[1],"-")==0) strcpy(ObjectFileName,"");
          else strcpy(ObjectFileName,argv[1]);
          if (J3WNew(ObjectFileName) == 0) {
              cout << '\n' << " File not found or too big" << '\n';
              J3WClose();
              return 0;
          }
          cout << " Execute file : " << argv[1] << '\n';
          J3WStart();
          while (J3WLoop() == 0) ;
        }
    } else {
        cout << " usage : j3w [-f] file \n ";
    }
    J3WClose();
    return 0;
}
