/*-------------------------------------------------------------------------*/
/*  J3W ver 6.50 3D Animation Kit                                          */
/*  scrnx.h       01/02/2006                                               */
/*  Copyright (C) 1997 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_scrnx_h)
#define _scrnx_h

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "screen.h"

const int PSEUDOCOLOR = 0;
const int TRUECOLOR   = 1;

class ScrnX : public TScreen {
    int ncol;
    XColor  col[256];
    Display *d;
    Window  w;
    Font    f;
    GC      gc;
    GC      gcf;
    Pixmap  p;
    Colormap    cmap;
    int color_mode;
    int     mode;
    unsigned int  rshift;
    unsigned int  gshift;
    unsigned int  bshift;
    unsigned int  rbits;
    unsigned int  gbits;
    unsigned int  bbits;
    XSetWindowAttributes attr;
    XStandardColormap *stdcmap;
    unsigned int  black, white;
    void OpenX();
    void SetupColorInfo();
    void SetColorMap(Visual* vis);
    unsigned int  SearchColor(int  r, int  g, int  b);
  public:
    ScrnX();
    virtual ~ScrnX();
    Display *GetDisplay();
    Window  *GetWindow();
    virtual int  set_mode(int mode);
    virtual void restore_mode();
    virtual void update();
    virtual void clear();
    virtual int  line(Vector2D p1, Vector2D p2, int color);
    virtual int  line_rgb(Vector2D p1, Vector2D p2, int r, int g, int b);
    virtual int  point(Vector2D p, int color);
    virtual int  polygon(Vector2D *vp, int vn, int color);
    virtual int  write_text(int x, int y,int color, char* text);
    virtual void SetPaletteEntry(int n, int r , int g, int b);
    virtual void UpdatePalette();
    int  polygon_rgb(Vector2D *vp, int vn, int r, int g, int b);
    int  GetColorMode() { return color_mode; };
};

#endif

