/*-------------------------------------------------------------------------*/
/*  J3W ver 6.50  3D Animation Kit                                         */
/*  timing.h      01/02/2006                                               */
/*  Copyright (C) 1995 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_timing_h)
#define _timing_h

#include <sys/time.h>
#include <unistd.h>

class cTiming {
    timeval  start, now, losstime;
    struct timezone tzone;
    int    msec;
  public:
    cTiming() {}
    ~cTiming() {}
    void StartTimer() { gettimeofday(&start, &tzone); }
    void PauseTimer() { gettimeofday(&losstime, &tzone); }
    void RestartTimer() {
        gettimeofday(&now, &tzone);
        start.tv_sec += now.tv_sec - losstime.tv_sec;
        start.tv_usec += now.tv_usec - losstime.tv_usec;
    }
    int  GetTime() {
        gettimeofday(&now, &tzone);
        msec = (now.tv_sec - start.tv_sec)*1000 +
                    int ((now.tv_usec - start.tv_usec)/1000);
        return msec;
    }
    int  GetTick() { return 1; }
    int  GetPeriodInTick () { return GetTime(); }
};

#endif

