/*-------------------------------------------------------------------------*/
/*  J3W ver 6.50  3D Animation Kit                                         */
/*  tpolygon.h    01/02/2006                                               */
/*  Copyright (C) 1996 - 2006 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_tpolygon_h)
#define _tpolygon_h

#include  "vertex.h"

struct  Polygon3D {
    int  color;
    int  n;
    double reflection;
    double ambient;
    int  f_normal;
    Vector_d    normal;
    Vector_d    enormal;
    int  off_center;
    int  *index;
};

class  TPolygons {
    int  Max;
    int  Count;
    double reflection;
    double ambient;
    int  off_center;

  public:
    TVertex   Vertex;
    Polygon3D **pg;

    TPolygons(int vn, int pn);
    ~TPolygons();
    int  GetCount() { return Count; };
    void Add(int n, int color, const int *idx);

    void SetPoly(int pos, int color, const int *idx);

    void GetPoly(int pos, int &color, int *idx);

    int  GetVertexCount(int pos);

    void SetReflection(double ref) { reflection = ref; }

    void SetAmbient(double amb) { ambient = amb; }

    void SetCenterGrav(int  cg) { off_center = cg; }

};

#endif
